/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.Gnetum;
import me.decce.gnetum.PackedVanillaElements;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.util.AnyBooleanValue;
import me.decce.gnetum.util.TriStateBoolean;
import me.decce.gnetum.util.TwoStateBoolean;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class GnetumConfig {
    public static final int UNLIMITED_FPS = 125;
    private static final Path PATH = FMLPaths.CONFIGDIR.get().resolve("gnetum.json");
    public TwoStateBoolean enabled = new TwoStateBoolean(AnyBooleanValue.ON);
    public TwoStateBoolean showHudFps = new TwoStateBoolean(AnyBooleanValue.ON);
    public int numberOfPasses = 4;
    public int maxFps = 60;
    public Map<String, CacheSetting> mapVanillaElements = new HashMap<String, CacheSetting>();
    public Map<String, CacheSetting> mapModdedElementsPre = new HashMap<String, CacheSetting>();
    public Map<String, CacheSetting> mapModdedElementsPost = new HashMap<String, CacheSetting>();

    public boolean isEnabled() {
        return this.enabled.get();
    }

    private static GnetumConfig createDefault() {
        GnetumConfig config = new GnetumConfig();
        config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
        return config;
    }

    private static GnetumConfig load() {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                return GnetumConfig.createDefault();
            }
            String json = Files.readString(PATH);
            Gson gson = new Gson();
            GnetumConfig config = (GnetumConfig)gson.fromJson(json, GnetumConfig.class);
            if (!config.mapVanillaElements.containsKey("gnetum:minecraft_hand")) {
                config.mapVanillaElements.put("gnetum:minecraft_hand", new CacheSetting(1, new TriStateBoolean(AnyBooleanValue.AUTO, false)));
            }
            config.mapVanillaElements.get((Object)"gnetum:minecraft_hand").enabled.defaultValue = false;
            config.validate(true);
            return config;
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to read configuration!", (Throwable)e);
            return GnetumConfig.createDefault();
        }
    }

    public void validate(boolean full) {
        if (full) {
            this.numberOfPasses = GnetumConfig.clamp(this.numberOfPasses, 2, 10);
            this.mapVanillaElements.forEach((s, c) -> {
                c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
            });
            this.mapModdedElementsPost.forEach((s, c) -> {
                c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
            });
            this.maxFps = GnetumConfig.clamp(this.maxFps, 1, 125);
            this.removeElementsFromUninstalledMods();
            this.removeObsoleteVanillaElements();
        }
        this.mapModdedElementsPre.forEach((s, c) -> {
            c.pass = GnetumConfig.clamp(c.pass, 1, this.numberOfPasses);
            TriStateBoolean triStateBoolean = c.enabled;
            triStateBoolean.defaultValue = switch (s) {
                case "xaerominimap" -> false;
                default -> true;
            };
        });
    }

    private void removeElementsFromUninstalledMods() {
        ArrayList<String> toRemove = new ArrayList<String>();
        this.mapModdedElementsPre.forEach((s, c) -> {
            if (!ModList.get().isLoaded(s)) {
                toRemove.add((String)s);
            }
        });
        this.mapModdedElementsPost.forEach((s, c) -> {
            if (!ModList.get().isLoaded(s)) {
                toRemove.add((String)s);
            }
        });
        toRemove.forEach(s -> {
            this.mapModdedElementsPre.remove(s);
            this.mapModdedElementsPost.remove(s);
        });
        toRemove.clear();
        this.mapVanillaElements.forEach((s, c) -> {
            int semicolon = s.indexOf(58);
            if (semicolon == -1) {
                return;
            }
            String modid = s.substring(0, semicolon);
            if (!ModList.get().isLoaded(modid)) {
                toRemove.add((String)s);
            }
        });
        toRemove.forEach(s -> this.mapVanillaElements.remove(s));
    }

    private void removeObsoleteVanillaElements() {
        PackedVanillaElements.getMap().forEach((key, value) -> Arrays.stream(value.getOverlays()).forEach(key1 -> this.mapVanillaElements.remove(key1)));
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static void reload() {
        Gnetum.config = GnetumConfig.load();
    }

    public static void reset() {
        Gnetum.config = GnetumConfig.createDefault();
        Gnetum.config.save();
    }

    public void save() {
        this.validate(true);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)this);
        try {
            Files.writeString(PATH, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            Gnetum.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
        if (PerformanceAnalyzer.latestAnalysisResult != null) {
            PerformanceAnalyzer.latestAnalysisResult.markOutdated();
        }
    }
}

